//%attributes = {"publishedSql":true}
// Method: _blob_ TBL_XML
// 2005.10.24-15:12:31 / ME
// © Copyright 2005 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------

C_LONGINT:C283($_blob_lAction; $1; $_blob_lTbl; $3; $_blob_lInsertMode; $4; $_blob_lTempBlobSize)
C_POINTER:C301($_blob_pData; $_blob_pFld)
C_TEXT:C284($_blob_tInsertPoint; $5)
C_BLOB:C604($_blob_xTempBlob)

$_blob_lAction:=$1  // kSave = save data to xml blob | kLoad = load data from xml blob
$_blob_pData:=$2  // pointer to data blob
$_blob_lTbl:=_rd_ To4DTblNum($3)  // table number
$_blob_lInsertMode:=$4  // kSave: kAdd | kInsert | kReplace | kNew;  kLoad: kOpen | kSave | kReceive
$_blob_tInsertPoint:=$5  // tag name used to determine where to add

Case of 
	: (Type:C295($_blob_pData->)#Is BLOB:K8:12)
		_err MESSAGE_PARAMETER("$2 not BLOB pointer"; Current method name:C684; kFalse)
	Else 
		Case of 
			: ($_blob_lAction=kSave)
				C_LONGINT:C283($_blob_lPosition; $_blob_lFld; $_blob_lFldIndex; $_blob_lFldCount; $_blob_lRecIndex; $_blob_lRecCount)
				C_TEXT:C284($_blob_tXmlData; $_blob_tTag)
				Case of 
					: ($_blob_lInsertMode=kAdd)
						// TODO: search the tag and insert position            
						If ($_blob_tInsertPoint#"")  // add after this tag
							$_blob_lPosition:=BLOB size:C605($_blob_pData->)
						Else   // append to the end
							$_blob_lPosition:=BLOB size:C605($_blob_pData->)
						End if 
						// insert xml version            
						$_blob_tXmlData:="<?xml version="+ksQuoteDouble+"1.0"+ksQuoteDouble+" encoding="+ksQuoteDouble+"ISO-8859-1"+ksQuoteDouble+"?>"+ksCR
						TEXT TO BLOB:C554($_blob_tXmlData; $_blob_pData->; Mac text without length:K22:10; $_blob_lPosition)
						
						_rec FIRST($_blob_lTbl)
						$_blob_lRecCount:=_sel RecsInSel($_blob_lTbl)
						For ($_blob_lRecIndex; 1; $_blob_lRecCount)
							// insert table tag, name is id str (_prf_ etc.)
							$_blob_lFldCount:=_tbl FldCount($_blob_lTbl)
							$_blob_tTag:=_tbl NumToIdStr($_blob_lTbl)
							$_blob_tXmlData:="<"+$_blob_tTag+">"+ksCR
							TEXT TO BLOB:C554($_blob_tXmlData; $_blob_pData->; Mac text without length:K22:10; $_blob_lPosition)
							
							// go through the fields and create tags, name is field constant (_prf_kName etc.)
							For ($_blob_lFldIndex; 1; $_blob_lFldCount)
								$_blob_lFld:=_rd_ 4DToLocalNum($_blob_lTbl; $_blob_lFldIndex)
								$_blob_tTag:=_fld NameConstant($_blob_lFld)
								$_blob_tXmlData:=ksTab+"<"+$_blob_tTag+">"
								TEXT TO BLOB:C554($_blob_tXmlData; $_blob_pData->; Mac text without length:K22:10; $_blob_lPosition)
								
								// write field data
								Case of 
										// TODO: perhaps write picture to blob and then base64?
									: (_fld Type($_blob_lFld)=Is picture:K8:10)
										TRACE:C157  //do this
										
										// blobs are compressed and encoded to base64
									: (_fld Type($_blob_lFld)=Is BLOB:K8:12)
										$_blob_pFld:=_fld NumToPtr($_blob_lFld)
										COMPRESS BLOB:C534($_blob_pFld->; Compact compression mode:K22:12)
										$_blob_xTempBlob:=$_blob_pFld->
										BASE64 ENCODE:C895($_blob_xTempBlob)
										$_blob_lTempBlobSize:=BLOB size:C605($_blob_xTempBlob)
										COPY BLOB:C558($_blob_xTempBlob; $_blob_pData->; 0; $_blob_lPosition; $_blob_lTempBlobSize)
										$_blob_lPosition:=$_blob_lPosition+$_blob_lTempBlobSize
										
										// other data to txt, encode special chars and transform to latin-1
									Else 
										$_blob_tXmlData:=_fld ToTxt($_blob_lFld; "")
										$_blob_tXmlData:=Replace string:C233($_blob_tXmlData; "<"; "&lt;")  // prevent parse errors with text fields..
										$_blob_tXmlData:=Replace string:C233($_blob_tXmlData; ">"; "&gt;")
										$_blob_tXmlData:=Replace string:C233($_blob_tXmlData; ksCRLF; "&crlf;")
										$_blob_tXmlData:=Replace string:C233($_blob_tXmlData; ksCR; "&cr;")
										$_blob_tXmlData:=_O_Mac to ISO:C519($_blob_tXmlData)  //1 = use ISO-8859-1 table (Latin-1)
										TEXT TO BLOB:C554($_blob_tXmlData; $_blob_pData->; Mac text without length:K22:10; $_blob_lPosition)
								End case 
								
								// create end tags              
								$_blob_tXmlData:="</"+$_blob_tTag+">"+ksCR
								TEXT TO BLOB:C554($_blob_tXmlData; $_blob_pData->; Mac text without length:K22:10; $_blob_lPosition)
							End for 
							$_blob_tTag:=_tbl NumToIdStr($_blob_lTbl)
							$_blob_tXmlData:="</"+$_blob_tTag+">"+ksCR
							TEXT TO BLOB:C554($_blob_tXmlData; $_blob_pData->; Mac text without length:K22:10; $_blob_lPosition)
							_rec NEXT($_blob_lTbl)
						End for 
						_rec UNLOAD($_blob_lTbl)
					: ($_blob_lInsertMode=kInsert)
						If ($_blob_tInsertPoint#"")  // insert inside this tag
							$_blob_lPosition:=BLOB size:C605($_blob_pData->)
						Else   // append to the end
							$_blob_lPosition:=BLOB size:C605($_blob_pData->)
						End if 
						//  : ($_blob_lInsertMode=kReplace) ` ?
						// : ($_blob_lInsertMode=kNew) ` ?
					Else 
				End case 
				
			: ($_blob_lAction=kLoad)
				ARRAY TEXT:C222(_blob_atData; 0)
				C_TEXT:C284($_blob_tRow; $_blob_tFldConstant; $_blob_tFldData)
				C_LONGINT:C283($_blob_lStartPosition; $_blob_lEndPosition; $_blob_lArrPos; $_blob_lFld; $_blob_lArrIndex; $_blob_lFldType)
				C_POINTER:C301($_blob_pFld)
				C_BLOB:C604(_blob_xTemp)
				SET BLOB SIZE:C606(_blob_xTemp; 0)
				
				// read xml data to text array
				_blob_ TBL_XML_TO_ARR($_blob_pData; ->_blob_atData)
				
				// find the table tag from array
				$_blob_tTag:=_tbl NumToIdStr($_blob_lTbl)
				$_blob_lStartPosition:=Find in array:C230(_blob_atData; "< "+$_blob_tTag)+1
				$_blob_lEndPosition:=Find in array:C230(_blob_atData; "</"+$_blob_tTag)-1
				
				// find the uuid tag and get the uuid
				$_blob_lFld:=_tbl_ UUIDFldNum($_blob_ltbl)
				$_blob_tFldConstant:=_fld NameConstant($_blob_lFld)
				$_blob_lArrPos:=Find in array:C230(_blob_atData; "< "+$_blob_tFldConstant)
				_text:=_blob_atData{$_blob_lArrPos+1}
				
				_tbl WRITE_STATE($_blob_lTbl; kTrue)
				
				// search the record by uuid, load if exists, create new if not
				C_LONGINT:C283($_blob_lSelSize)
				$_blob_lSelSize:=_qry Fld($_blob_lTbl; $_blob_lFld; "="; ->_text; ""; kFalse)
				If ($_blob_lSelSize>0)  // record exists
					_rec LOAD($_blob_lTbl)
					_rec LOCKED_WAIT($_blob_lTbl; kTrue)
					If (OK=1)
						
					End if 
				Else   // record doesn't exist
					_rec CREATE($_blob_lTbl)
				End if 
				
				// go through the text array and save the field data
				For ($_blob_lArrIndex; $_blob_lStartPosition; $_blob_lEndPosition)
					$_blob_tXmlData:=_blob_atData{$_blob_lArrIndex}
					
					If ($_blob_tXmlData[[1]]="<")
						If ($_blob_tXmlData[[2]]="/")  // it is an end tag
							// if finishing a blob tag, decode, expand and save the data              
							If ($_blob_lFldType=Is BLOB:K8:12)
								BASE64 DECODE:C896(_blob_xTemp)
								EXPAND BLOB:C535(_blob_xTemp)
								_fld VALUE(kSet; $_blob_lFld; ->_blob_xTemp)
								SET BLOB SIZE:C606(_blob_xTemp; 0)
								$_blob_lFldType:=0  // prevent from returning here if next tag is empty
							End if 
						Else   // it is a start tag
							$_blob_tTag:=Substring:C12($_blob_tXmlData; 3)
						End if 
					Else   // it is tag data
						$_blob_tFldConstant:=$_blob_tTag
						$_blob_lFld:=_var ConstantNameToLong($_blob_tFldConstant)
						$_blob_lFldType:=_fld Type($_blob_lFld)
						
						C_LONGINT:C283($_blob_lLongValue)
						C_REAL:C285($_blob_rRealValue)
						Case of 
							: ($_blob_lFldType=Is BLOB:K8:12)
								TEXT TO BLOB:C554($_blob_tXmlData; _blob_xTemp; Mac text without length:K22:10; *)  // add to end, may be in many parts
							: ($_blob_lFldType=Is picture:K8:10)
								
							: (($_blob_lFldType=Is integer:K8:5) | ($_blob_lFldType=Is longint:K8:6))
								// convert data to long and save                
								$_blob_lLongValue:=Num:C11($_blob_tXmlData)
								_fld VALUE_LONG_SET(kSet; $_blob_lFld; $_blob_lLongValue)
								
							: ($_blob_lFldType=Is real:K8:4)
								// convert data to real and save                
								$_blob_rRealValue:=Num:C11($_blob_tXmlData)
								_fld VALUE_REAL_SET(kSet; $_blob_lFld; $_blob_rRealValue)
								
							: ($_blob_lFldType=Is date:K8:7)
							: ($_blob_lFldType=Is time:K8:8)
								
							: (($_blob_lFldType=Is alpha field:K8:1) | ($_blob_lFldType=Is text:K8:3))
								// special chars need to be decoded      
								$_blob_tXmlData:=Replace string:C233($_blob_tXmlData; "&lt;"; "<")  // prevent parse errors with text fields..
								$_blob_tXmlData:=Replace string:C233($_blob_tXmlData; "&gt;"; ">")
								$_blob_tXmlData:=Replace string:C233($_blob_tXmlData; "&crlf;"; ksCRLF)
								$_blob_tXmlData:=Replace string:C233($_blob_tXmlData; "&cr;"; ksCR)
								_fld VALUE_STR_SET(kSet; $_blob_lFld; $_blob_tXmlData)
							Else 
								_err MESSAGE(_lang Current("Unknown data type"); Current method name:C684; kTrue)
						End case 
					End if 
				End for 
				_rec SAVE($_blob_lTbl)
				_rec UNLOAD($_blob_lTbl)
				
				_tbl WRITE_STATE($_blob_lTbl; kPrevious)
			Else 
				_err MESSAGE_PARAMETER("$1 action is not valid"; Current method name:C684; kFalse)
		End case 
End case 
